function ControlApp() {
    this.headset = 1;
    this.play = 2;
    this.pause = 3;
    this.stop = 4;
    this.volumePlus = 5;
    this.volumeMinus = 6;
    this.volumeSteps= 10;
    this.stopDelay = 5000;
    this.timeout = undefined;
    this.currentState = "stop"; // play | pause | stop
};
ControlApp.prototype = {
	initilialize: function(ifaces) {
		this.ifaces = ifaces;
        // to force webapp to control inputs
        var config = {
            controller: "browser",
            lifetime: "url"
        };
        this.ifaces.contact.setInputConfiguration(config)
            .then(function(e) {
                console.log("Contact.setInputConfiguration(" + JSON.stringify(config) + ") => " + JSON.stringify(e));
            })
            .catch(function(e) {
                console.error("Error: Contact.setInputConfiguration(" + JSON.stringify(config) + ") => " + JSON.stringify(e));
            });
        this.getApplicationConfiguration()
            .then((config) => {
                this.headset = config.headset;
                this.play = config.play;
                this.pause = config.pause;
                this.stop = config.stop;
                this.volumePlus = config.volumePlus;
                this.volumeMinus = config.volumeMinus;
                this.volumeSteps = config.volumeSteps;
                this.stopDelay = config.stopDelay;
            })
            .catch(() => console.error("Erreur lors du chargement de la configuration (config.json)"));
		/**
         * Listen every contact events
         */
        this.ifaces.contact.addListener((event) => {
            const info = event.detail;
			if (info.type === 'input-change') {
				let inputActive = [];
				/**
				 * check all input-states and store them inside an array
				 */
				for (var i = 0 ; i < info.values.length ; i++) {
					if (info.values[i] === true) {
                        // i+1 because difference between GPI number and i
						inputActive.push(i+1);
					}
				}
				
				/**
				 * if at least one input return true => get infos of the input
				 */
				if (inputActive.length > 0) {
                    // console.log("inputActive", inputActive);
                    // if headset is triggered => enable buttons
                    if (inputActive.includes(this.headset)) {
                        if (inputActive.includes(this.play)) {
                            // if timeout is not finished => clear it
                            if (this.timeout) {
                                clearTimeout(this.timeout);
                                this.timeout = undefined;
                            }
                            if (this.currentState === "pause") {
                                this.ifaces.player.play();
                            } else {
                                this.ifaces.player.playFolder(1);
                            }
                            this.currentState = "play"; // play | pause | stop
                            console.log("Play");
                        } else if (inputActive.includes(this.pause)) {
                            if (this.timeout) {
                                clearTimeout(this.timeout);
                                this.timeout = undefined;
                            }
                            this.ifaces.player.pause();
                            this.currentState = "pause";
                            this.timeout = setTimeout(() => {
                                console.log("stopped after " + this.stopDelay + "s (stopdelay)")
                                this.ifaces.player.stop();
                                this.timeout = undefined;
                            }, this.stopDelay);
                            console.log("Pause");
                        } else if (inputActive.includes(this.stop)) {
                            this.ifaces.player.stop();
                            if (this.timeout) {
                                clearTimeout(this.timeout);
                                this.timeout = undefined;
                            }
                            console.log("Stop");
                        } else if (inputActive.includes(this.volumePlus)) {
                            this.ifaces.player.setVolume(this.volumeSteps, true);
                            console.log("Volume +++");
                        } else if (inputActive.includes(this.volumeMinus)) {
                            this.ifaces.player.setVolume(-this.volumeSteps, true);
                            console.log("Volume ---");
                        }
                    }
				} else {
                    // if headset is on support => stop playing
                    if (this.currentState !== "stop") {
                        this.ifaces.player.stop();
                        this.currentState = "stop";
                        if (this.timeout) {
                            clearTimeout(this.timeout);
                            this.timeout = undefined;
                        }
                    }
                }
			}
        });
	},

    getApplicationConfiguration: function() {
        return new Promise(function(resolve, reject) {
            var xhr = new XMLHttpRequest();
            xhr.addEventListener("readystatechange", function() {
                if(this.readyState === 4) {
                    if (xhr.status === 200) {
                        try {
                            var response = JSON.parse(this.responseText);
                            resolve(response);
                        } catch(e) {
                            reject(e);
                        }
                    } else {
                        reject("Invalid HTTP response status " + xhr.status);
                    }
                }
            });
            xhr.open("GET", "config.json");
            xhr.send();
        });
    },
};

// initialize app + controler
window.addEventListener('load', function() {
IDAL.getControlInterfaces()
	.then(function(ifaces) {
		var app = new ControlApp();
		app.initilialize(ifaces);
	})		
});