const STOP_TIMEOUT = 3 * 60 * 1000; // Milliseconds

const BUTTON1 = 0;
const BUTTON2 = 1;
const BUTTON3 = 2;
const BUTTON4 = 3;
const BUTTON5 = 4;
const BUTTON6 = 5;
const FR = 1;
const EN = 2;
const ESP = 3;
function PlayerTwoApp() {
    this.iface = null;
    this.contacts = [false, false, false, false, false, false, false, false];
    this.allowed = [true, true, true, true, true, true];
    this.currentFolder = -1;
     this.currentLang = FR;
    this.timeout = null;
}

PlayerTwoApp.prototype = {
    initialize: function(iface) {
        this.iface = iface;

        console.log("Stop timeout is " + (STOP_TIMEOUT / 1000) + " seconds");

        // Disable default input contact management.
        // Input contacts will be managed by this app.
        var config = {
            controller: "browser",
            lifetime: "url"
        };

        iface.contact.setInputConfiguration(config)
            .then(function(e) {
            })
            .catch(function(e) {
                console.error("Error: Contact.setInputConfiguration(" + JSON.stringify(config) + ") => " + JSON.stringify(e));
            });

        // Get the current folder number
        iface.player.getFolderNumber()
            .then(function(idx) {
                    this.currentFolder = idx;
                }.bind(this));

        // Listen to contact events
        iface.contact.addListener(this.onContactChange.bind(this));

        // Listen to player evens
        iface.player.addListener(this.onPlayerEvent.bind(this));
    },

    onContactChange: function(e) {
        // Process input contact events
        var detail = e.detail;

        switch (detail.name) {
            case "combined":
                // Find first modified and pressed contact
                var button = -1;
                for (var i = 0 ; (button == -1) && (i < detail.values.length) ; i++) {
                    var val = detail.values[i];
                    if ((val != this.contacts[i]) && (val))  {
                        button = i;
                    }
                }

                if (button != -1) {
                    console.log("Press button n°" + (button + 1));
                }

                switch(button) {
                    case BUTTON1:
                        if (this.getAndClearAllowed(BUTTON1)) {
                            this.clearStopTimeout();
                            this.playFolder(400);
                        }
                        break;

                    case BUTTON2:
                        console.log("No action for button 2");
                        break;

                    case BUTTON3:
                        if (this.currentFolder == 400) {
                            if (this.getAndClearAllowed(BUTTON3)) {
                                this.stopAfterTimeout(STOP_TIMEOUT);
                            }
                        } else {
                            console.log("Can only stop when playing folder 1");
                        }
                        break;

                    case BUTTON4: // FR
                        this.clearStopTimeout();
                        this.playFolder(100);
                        this.allowEveryButton();
                        break;
                    case BUTTON5: // EN
                        this.clearStopTimeout();
                        this.playFolder(200);
                        this.allowEveryButton();
                        break;
                    case BUTTON6: // ESP
                        this.clearStopTimeout();
                        this.playFolder(300);
                        this.allowEveryButton();
                        break;
                }
                break;

            case "standalone":
                break;
        }
    },

    playFolder: function(i) {
        console.log("Play folder n°" + i);
        this.iface.player.playFolder(i);
    },

    clearStopTimeout: function() {
        if (this.timeout != null) {
            console.log("Cancel deferred stop");
            window.clearTimeout(this.timeout);
            this.timeout = null;
        }
    },

    stopAfterTimeout: function(duration) {
        this.clearStopTimeout();
        console.log("Stop will occur in " + (duration / 1000) + " seconds");
        this.timeout = window.setTimeout(this.onStopTimeout.bind(this), duration);
    },

    onStopTimeout: function() {
        console.log("Stopping playback, timeout reached");
        this.timeout = null;
        this.iface.player.stop();
    },

    getAndClearAllowed: function(button) {
        if (this.allowed[button]) {
            this.allowed[button] = false;
            return true;
        }
        console.log("Action on button n°" + (button + 1) + " is not allowed in current state");
        return false;
    },

    allowEveryButton: function() {
        for (var i = 0 ; i < this.allowed.length ; i++) {
            this.allowed[i] = true;
        }
    },

    onPlayerEvent: function(e) {
        var detail = e.detail;
        if (detail.type == 'folder-enter') {
            this.currentFolder = detail.folder.number;
        } else if (detail.type == 'folder-leave') {
            this.currentFolder = -1;
        }
    }
};