const BUTTON1 = 0;
const BUTTON2 = 1;
const BUTTON3 = 2;
const BUTTON4 = 3;
const BUTTON5 = 4;
const BUTTON6 = 5;
const STOP_TIMEOUT = 3 * 60 * 1000; // (3min) Milliseconds
const FR = 1;
const EN = 2;
const ESP = 3;

function PlayerOneApp() {
    this.iface = null;
    this.contacts = [false, false, false, false, false, false, false, false];
    this.allowed = [true, true, true, true, true, true];
    this.currentFolder = -1;
    this.currentLang = FR;
    this.timeout = null;
}

PlayerOneApp.prototype = {
    initialize: function(iface) {
        this.iface = iface;

        // Disable default input contact management.
        // Input contacts will be managed by this app.
        var config = {
            controller: "browser",
            lifetime: "url"
        };

        iface.contact.setInputConfiguration(config)
            .then(function(e) {
                console.log("Contact.setInputConfiguration(" + JSON.stringify(config) + ") => " + JSON.stringify(e));
            })
            .catch(function(e) {
                console.error("Error: Contact.setInputConfiguration(" + JSON.stringify(config) + ") => " + JSON.stringify(e));
            });

        // Get the current folder number
        iface.player.getFolderNumber()
            .then(function(idx) {
                    this.currentFolder = idx;
                }.bind(this));

        // Listen to contact events
        iface.contact.addListener(this.onContactChange.bind(this));

        // Listen to player evens
        iface.player.addListener(this.onPlayerEvent.bind(this));
    },

    onContactChange: function(e) {
        // Process input contact events
        var detail = e.detail;

        switch (detail.name) {
            case "combined":
                // Find first modified and pressed contact
                var button = -1;
                for (var i = 0 ; (button == -1) && (i < detail.values.length) ; i++) {
                    var val = detail.values[i];
                    if ((val != this.contacts[i]) && (val))  {
                        button = i;
                    }
                }

                if (button != -1) {
                    console.log("Press button n°" + (button + 1));
                }

                switch(button) {
                    case BUTTON1: // Should play folder 101 | 201 | 301
                        if (this.getAndClearAllowed(BUTTON1)) {
                            this.playFolder(parseInt(`${this.currentLang}01`));
                            console.log("this.currentFolder = ", this.currentFolder, parseInt(`${this.currentLang}01`))
                        }
                        break;

                    case BUTTON2: // Should play folder 102 | 202 | 302
                        if (this.currentFolder == 102 || this.currentFolder == 202 || this.currentFolder == 302) {
                            this.togglePause();
                        } else {
                            if (this.getAndClearAllowed(BUTTON2)) {
                                this.playFolder(parseInt(`${this.currentLang}02`));
                                console.log("this.currentFolder = ", this.currentFolder, parseInt(`${this.currentLang}02`))
                            }
                        }
                        break;

                    case BUTTON3: // Should stop playing folder selected by btn 2 after 3'
                        if (this.currentFolder == 102 || this.currentFolder == 202 || this.currentFolder == 302) {
                            if (this.getAndClearAllowed(BUTTON3)) {
                                this.stopAfterTimeout(STOP_TIMEOUT);
                            }
                        } else {
                            console.log("Current folder is not N°2, don't stop");
                        }
                        break;

                    case BUTTON4: // Should set FR lang or replay current playback
                        this.playFolder(100);
                        this.currentLang = FR;
                        this.allowEveryButton();
                        break;

                    case BUTTON5: // Should set EN lang or replay current playback
                        this.playFolder(200);
                        this.currentLang = EN;
                        this.allowEveryButton();
                        break;

                    case BUTTON6: // Should set ESP lang or replay current playback
                        this.playFolder(300);
                        this.currentLang = ESP;
                        this.allowEveryButton();
                        break;
                }
                break;

            case "standalone":
                break;
        }
    },

    togglePause: function() {
        console.log("Toggle pause");
        this.iface.player.togglePause();
    },

    stop: function() {
        console.log("Stop playback");
        this.iface.player.stop();
    },

    playFolder: function(i) {
        this.clearStopTimeout();
        console.log("Play folder n°" + i);
        this.iface.player.playFolder(i);
    },

    getAndClearAllowed: function(button) {
        if (this.allowed[button]) {
            this.allowed[button] = false;
            return true;
        }
        console.log("Action on button n°" + (button + 1) + " is not allowed in current state");
        return false;
    },

    allowEveryButton: function() {
        for (var i = 0 ; i < this.allowed.length ; i++) {
            this.allowed[i] = true;
        }
    },

    clearStopTimeout: function() {
        if (this.timeout != null) {
            console.log("Cancel deferred stop");
            window.clearTimeout(this.timeout);
            this.timeout = null;
        }
    },

    stopAfterTimeout: function(duration) {
        this.clearStopTimeout();
        console.log("Stop will occur in " + (duration / 1000) + " seconds");
        this.timeout = window.setTimeout(this.onStopTimeout.bind(this), duration);
    },

    onStopTimeout: function() {
        console.log("Stopping playback, timeout reached");
        this.timeout = null;
        this.iface.player.stop();
    },

    onPlayerEvent: function(e) {
        var detail = e.detail;
        if (detail.type == 'folder-enter') {
            this.currentFolder = detail.folder.number;
        } else if (detail.type == 'folder-leave') {
            this.currentFolder = -1;
        }
    }
};